/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements. The ASF licenses this
file to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.   
*/

#pragma once

#include "Max.h"
#include "istdplug.h"
#include "iparamb2.h"
#include "iparamm2.h"

#include "particle.h"
#include "Simpobj.h"
#include "splshape.h"

#include "meshadj.h"
#include "XTCObject.h"

#include "IParticleObjectExt.h"

#include "maxobject.h"

/*
	Extracts the point cloud (position and speed) from max
*/
class readPointCloud {
private:
	Tab<VR::Vector> posTab; // Position
	Tab<VR::Vector> velTab; // Velocity
	Tab<float> radTab; // Radius
	Tab<float> chaTab; // Change of radius		
	Tab<VR::Vector> colTab; // Colors
	
	bool useRadii;	
	bool useColors;
	float zero;
	 
	void readVertexColors(Mesh theMesh);
	bool readTriMesh(INode *node, TimeValue time[2]);
	bool readTriMesh(INode *node, TimeValue time);
	
	bool readSimpleParticle(INode *node, TimeValue time[2]);
	bool readSimpleParticle(INode *node, TimeValue time);
	
	bool readExtParticle(INode *node, IParamBlock2 *pblock, TimeValue time[2]);	
	//bool readExtParticleVel(INode *node, IParamBlock2 *pblock, TimeValue time[2]); // Uses velocity channel and doesn't compute changing radius
	bool readExtParticle(INode *node, IParamBlock2 *pblock, TimeValue time);	
public:
	float defaultRadius; // Used by meshes when "Use radii" is on because vertices don't have radius

	/* If this is true, then pflow velocity channel is used for particle speed and change of radius is not computed
	   This mode is here because PFlows Spawn operator seems to cause some problems with particles randomly changing
	   places which causes lots of issues with motion blur. This is workaround, not a proper fix. The problem
	   can only be properly fixed at PFlows end. - Jerry Ylilammi (05.11.2009) TODO: Fix this properly? */	
	//bool usePFlowSpawnFix; 
	float velThresh; // Velocity threshold for pflow

	readPointCloud() {zero = 0.f; /*usePFlowSpawnFix = false;*/}
	~readPointCloud() {}
	void read(bool useRadii, bool useColors, int &pointCount, VR::Vector* &position, VR::Vector* &velocity, VR::Ireal* &radii, VR::Ireal* &radiiChange, VR::Vector* &colors, IParamBlock2 *pblock, TimeValue time[2]);
	void read(bool useRadii, bool useColors, int &pointCount, VR::Vector* &position, VR::Ireal* &radii, VR::Vector* &colors, IParamBlock2 *pblock, TimeValue time);
};

class Particle {
public:
	int id;
	VR::Vector position;	
	float radius;
	VR::Vector color;
};