/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements. The ASF licenses this
file to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.   
*/

#pragma once

#include "primitive.h"

/*
	Static version of the primitive
*/
class BerconMetaballPrimitiveStatic: public BerconMetaballPrimitive, public VR::StaticPrimitive {
private:			
	VR::StaticBox bb;
	int blobsCount;
	VR::Vector *blobs;
	VR::Ireal *radii;



	BoundingVolumeHierarchy* bvh;
	
public:
	BerconMetaballPrimitiveStatic() {
		bvh = new BoundingVolumeHierarchy();
		colors = NULL;
		blobs = NULL;
		radii = NULL;
	}

	~BerconMetaballPrimitiveStatic() {
		delete[] blobs;
		delete[] radii;
		delete[] colors;
		delete bvh;	
	}

	bool intersectTraditional(VR::Vector rO, VR::Vector rD, BVHStep* first, bool insideField, VR::Ireal stepLength, VR::Ireal maxError, VR::Ireal &dist);
	bool intersectAverage(VR::Vector rO, VR::Vector rD, BVHStep* first, bool insideField, VR::Ireal stepLength, VR::Ireal maxError, VR::Ireal &dist);	
	VR::Vector normal(VR::Vector location) const;

	inline void getAverageResult(FieldAvg &field, VR::Vector &pos) const;
	inline void getAverageResult(FieldGradAvg &grad) const;

	/* VRay interface */
	int expandable(void) { return false; }
	bool splittable(void) { return true; }	
	int intersect(VR::RSRay &ray);
	virtual VR::Vector getGNormal(VR::RSRay &ray) const;
	// virtual VR::Vector getGNormal(VR::RSRayRef& rayref);
	int getMemUsage(void) { return 0; }

	uint32 type(void) const { return BERCON_METABALL_PRIM_STATIC; }
	void getBBox(VR::StaticBox &bbox);
	void split(int dim, VR::real middle, VR::StaticBox &bLeft, VR::StaticBox &bRight);
	void init(MetaballParams params, VR::Vector* points, VR::Ireal *sizes, VR::Vector* colors, int pointCount, VR::GeometryGenerator *owner, int ownerIndex, VR::RayCache<MyCacheStruct> *rayc);
};