/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements. The ASF licenses this
file to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.   
*/

#pragma once

#include "instance.h"

class BerconMetaballInstanceStatic:
	public BerconMetaballInstance,
	public VR::VRenderInstance,
	public VR::Shadeable,
	public VR::StaticPrimitive
{
	VR::Transform tm, itm;
	Mesh dummyMesh;
	BerconMetaballPrimitiveStatic META;
	VR::RayCache<MyCacheStruct> raycache;
	int firstPrimID;

public:
	BerconMetaballInstanceStatic(BerconMetaball *META, INode *node, VR::VRayCore *vray, int renderID);
	~BerconMetaballInstanceStatic(void);

	// From StaticPrimitive
	void getBBox(VR::StaticBox &bbox) { META.getBBox(bbox); }
	void split(int dim, VR::real middle, VR::StaticBox &bLeft, VR::StaticBox &bRight) { META.split(dim, middle, bLeft, bRight); }

	int expand(VR::DynamicRaycaster<VR::StaticBox> *raycaster, int threadIndex) {
		if (-1==firstPrimID) firstPrimID=raycaster->getNewRenderID();
		raycaster->insertPrimitive(threadIndex, &META, static_cast<VR::GeometryGenerator*>(this), firstPrimID);
		return 0;
	}

	int collapse(VR::DynamicRaycaster<VR::StaticBox> *raycaster, int threadIndex) {
		raycaster->removePrimitive(threadIndex, &META);
		return 0;
	}

	// From VRenderInstance
	void renderBegin(TimeValue t, VR::VRayCore *vray);
	void frameBegin(TimeValue t, VR::VRayCore *vray);
	void compileGeometry(VR::VRayCore *vray);
	void frameEnd(VR::VRayCore *vray);
	void renderEnd(VR::VRayCore *vray);

	// From RenderInstance
	Interval MeshValidity(void);
	Point3 GetFaceNormal(int faceNum);
	Point3 GetFaceVertNormal(int faceNum, int vertNum);
	void GetFaceVertNormals(int faceNum, Point3 n[3]);
	Point3 GetCamVert(int vertNum);
	void GetObjVerts(int fnum, Point3 obp[3]);
	void GetCamVerts(int fnum, Point3 cp[3]);

	// From Shadeable
	void shade(VR::VRayContext &vri);

	// From ShadeData
	VR::Vector getUVWcoords(const VR::VRayContext &vri, int channel);
	void getUVWderivs(const VR::VRayContext &vri, int channel, VR::Vector derivs[2]);
	void getUVWbases(const VR::VRayContext &vri, int channel, VR::Vector bases[3]);
	VR::Vector getUVWnormal(const VR::VRayContext &vri, int channel);
	int getMtlID(const VR::VRayContext &vri);
	int getGBufID(void);
	int getSurfaceRenderID(const VR::VRayContext &rc);
	int getMaterialRenderID(const VR::VRayContext &rc);
	void getSmoothUVWbases(const VR::VRayContext &vri, int channel, VR::Vector bases[3]);

	// From ShadeInstance
	VR::Vector getBasePt(const VR::VRayContext &vri, BaseTime baseTime);
	VR::Vector getBasePtObj(const VR::VRayContext &vri);
	VR::Vector worldToObjectVec(const VR::VRayContext &vri, const VR::Vector &d);
	VR::Vector worldToObjectPt(const VR::VRayContext &vri, const VR::Vector &p);
	VR::Vector objectToWorldVec(const VR::VRayContext &vri, const VR::Vector &d);
	VR::Vector objectToWorldPt(const VR::VRayContext &vri, const VR::Vector &p);
	VR::Vector getBaseGNormal(const VR::VRayContext &vri, BaseTime baseTime);
	VR::Vector getBaseNormal(const VR::VRayContext &vri, BaseTime baseTime);
	VR::Vector getBaseBumpNormal(const VR::VRayContext &vri, BaseTime baseTime);
	VR::TracePoint getShadowPt(const VR::VRayContext &vri);
	VR::Vector getVelocity(const VR::VRayContext &vri);

	// From GeometryGenerator
	virtual void setIntersectionData(VR::RSRay& rsray, void *isData);
	// virtual void setIntersectionData(VR::RSRayRef& rsrayref, void *isData);

	// From DynamicPrimitive
	int expandable(void);
	bool splittable(void);
};
