/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements. The ASF licenses this
file to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.   
*/

#include "maxobject.h"
#include "3dsmaxport.h"

static PickControlNode thePickMode;

/*
	############ PFlow event add dialog proc ############
*/

static INT_PTR CALLBACK AddDlgProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {
	BerconMetaball *mod = DLGetWindowLongPtr<BerconMetaball*>(hWnd);
	switch (msg) {
		case WM_INITDIALOG: {
			mod = (BerconMetaball*)lParam;
			DLSetWindowLongPtr(hWnd, lParam);
			for (int i=0; i < mod->pfNodes.Count(); i++) {
				const TCHAR *name = mod->pfNodes[i]->GetName();
				if (name) {
					TCHAR title[200];
					_tcscpy(title,name);					
					SendMessage(GetDlgItem(hWnd,IDC_EVENTLIST),
					LB_ADDSTRING,0,(LPARAM)(TCHAR*)title);
				}
			}
			break;
		}
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDOK: {
					int listCt = (int)SendMessage(GetDlgItem(hWnd,IDC_EVENTLIST),LB_GETCOUNT,0,0);
					int selCt = (int)SendMessage(GetDlgItem(hWnd,IDC_EVENTLIST),LB_GETSELCOUNT ,0,0);
					int *selList;
					selList = new int[selCt];
					SendMessage(GetDlgItem(hWnd,IDC_EVENTLIST),LB_GETSELITEMS  ,(WPARAM) selCt,(LPARAM) selList);
					mod->addPFNodes.SetCount(selCt);
					for (int i=0; i < selCt; i++)
						mod->addPFNodes[i] = selList[i];
					delete [] selList;
					EndDialog(hWnd,1);
					break;
				}
			case IDCANCEL:
				mod->pfNodes.ZeroCount();
				EndDialog(hWnd,0);
				break;
			}
			break;
		case WM_CLOSE:
			mod->pfNodes.ZeroCount();
			EndDialog(hWnd, 0);
			break;
		default:
			return FALSE;
	}
	return TRUE;
}

/*
	############ MyEnumProc ############
*/

int MyEnumProc::proc(ReferenceMaker *rmaker) { 
	if (rmaker->SuperClassID()==BASENODE_CLASS_ID) {
		Nodes.Append(1, (INode **)&rmaker);  
		if( mbDoHalt )		
			return DEP_ENUM_HALT;
	}
	return DEP_ENUM_CONTINUE;
}

/*
	############ BerconMetaball ############
*/

void BerconMetaball::DisableButtons(HWND hWnd) {
	if (GetCOREInterface()->GetCommandPanelTaskMode() == TASK_MODE_CREATE) {
		ICustButton *iBut = GetICustButton(GetDlgItem(hWnd, IDC_ADD));
		if (iBut) {
			iBut->Enable(FALSE);
			ReleaseICustButton(iBut);
		}

		iBut = NULL;
		iBut = GetICustButton(GetDlgItem(hWnd, IDC_PICK));
		if (iBut) {
			iBut->Enable(FALSE);
			ReleaseICustButton(iBut);
		}
			
		iBut = NULL;
		iBut = GetICustButton(GetDlgItem(hWnd, IDC_REMOVE));
		if (iBut) {
			iBut->Enable(FALSE);
			ReleaseICustButton(iBut);
		}			
	} else {
		ICustButton *iBut = GetICustButton(GetDlgItem(hWnd, IDC_ADD));
		if (iBut) {
			iBut->Enable(TRUE);
			iBut->SetHighlightColor(GREEN_WASH);			
			ReleaseICustButton(iBut);
		}

		iBut = NULL;
		iBut = GetICustButton(GetDlgItem(hWnd, IDC_PICK));
		if (iBut) {
			iBut->Enable(TRUE);
			iBut->SetType(CBT_CHECK);
			iBut->SetHighlightColor(GREEN_WASH);
			ReleaseICustButton(iBut);
		}
	}
}

void BerconMetaball::fnAddNode(INode *node) {
	if (node == NULL) return;
	for (int i = 0; i < pblock2->Count(pb_nodes); i++) 
		if (node == pblock2->GetINode(pb_nodes, 0, i))
			return;
	node->BeginDependencyTest();
	NotifyDependents(FOREVER,0,REFMSG_TEST_DEPENDENCY);
	if (node->EndDependencyTest()) 
		return;		
	theHold.Begin();
	pblock2->Append(pb_nodes,1,&node);
	theHold.Accept(GetString(IDS_ADD));
	NotifyDependents(FOREVER, GEOM_CHANNEL, REFMSG_CHANGE);
	GetCOREInterface()->RedrawViews(GetCOREInterface()->GetTime());
}

void BerconMetaball::fnRemoveNode(INode *node) {
	int index = -1;
	if (node == NULL) return;
	for (int i = 0; i < pblock2->Count(pb_nodes); i++) {
		INode *pnode = NULL;
		pblock2->GetValue(pb_nodes,0,pnode,FOREVER,i);
		if (pnode == node) {
			index = i;
			i = pblock2->Count(pb_nodes);
		}
	}

	if (index != -1) {
		theHold.Begin();
		pblock2->Delete(pb_nodes,index,1);
		theHold.Accept(GetString(IDS_REMOVE_NODE));
		NotifyDependents(FOREVER, GEOM_CHANNEL, REFMSG_CHANGE);
		GetCOREInterface()->RedrawViews(GetCOREInterface()->GetTime());
	}
}


void BerconMetaball::fnAddPFNode(INode *node) {
	if (node == NULL) return;
	for (int i = 0; i < pblock2->Count(pb_pflow); i++)
		if (node == pblock2->GetINode(pb_pflow, 0, i))
			return;	
	node->BeginDependencyTest();
	NotifyDependents(FOREVER,0,REFMSG_TEST_DEPENDENCY);
	if (node->EndDependencyTest())
		return;
	theHold.Begin();
	pblock2->Append(pb_pflow,1,&node);
	theHold.Accept(GetString(IDS_ADD));
	NotifyDependents(FOREVER, GEOM_CHANNEL, REFMSG_CHANGE);
	GetCOREInterface()->RedrawViews(GetCOREInterface()->GetTime());
}

void BerconMetaball::fnRemovePFNode(INode *node) {
	int index = -1;
	if (node == NULL) return;
	for (int i = 0; i < pblock2->Count(pb_pflow); i++) {
		INode *pnode = NULL;
		pblock2->GetValue(pb_pflow,0,pnode,FOREVER,i);
		if (pnode == node) {
			index = i;
			i = pblock2->Count(pb_pflow);
		}
	}
	if (index != -1) {
		theHold.Begin();
		pblock2->Delete(pb_pflow,index,1);
		theHold.Accept(GetString(IDS_REMOVE_NODE));
		NotifyDependents(FOREVER, GEOM_CHANNEL, REFMSG_CHANGE);
		GetCOREInterface()->RedrawViews(GetCOREInterface()->GetTime());
	}
}


void BerconMetaball::fnPickMode() {
	thePickMode.hWnd = hWndNode;
	PickNodesMode();
	ICustButton *iBut = GetICustButton(GetDlgItem(hWndNode, IDC_PICK));
	if (iBut) {
		iBut->SetType(CBT_CHECK);
		iBut->SetCheck( inPickMode);
		ReleaseICustButton(iBut);
	}
}

void BerconMetaball::fnAddMode() {
	GetCOREInterface()->DoHitByNameDialog(new DumpHitDialog(this));
}

void BerconMetaball::fnAddPFMode() {
	PickPFEvents(hWndPF);
}

void BerconMetaball::RemoveSelectedNode() {
	int index = 0;
	index = (int)SendMessage(GetDlgItem(hWndNode, IDC_NODES),LB_GETCURSEL ,1,0);
	if (index == -1) return;
	int pblockIndex = 0;
	int ct = -1;
	for (int i = 0; i < pblock2->Count(pb_nodes);i++) {
		INode *pnode = NULL;
		pblock2->GetValue(pb_nodes,0,pnode,FOREVER,i);
		if (pnode != NULL) {
			ct++;
			if (ct == index) {
				pblockIndex = i;
				i = pblock2->Count(pb_nodes);
			}
		}
	}
	if ((pblockIndex < 0) || (pblockIndex >=pblock2->Count(pb_nodes)))
		return;
	INode * node = NULL;
	pblock2->GetValue(pb_nodes,0,node,FOREVER,pblockIndex);
	if (node)
		macroRecorder->FunctionCall(_T("$.BerconMetaballOps.RemoveBlob"), 1, 0, mr_reftarg,node);
}

void BerconMetaball::PickPFEvents(HWND hWnd) {	
	Tab<INode *> pfEvents;
	int numberOfNodes = pblock2->Count(pb_nodes);
	TimeValue t = GetCOREInterface()->GetTime();
	pfNodes.ZeroCount();
	addPFNodes.ZeroCount(); 
	for (int i = 0; i < numberOfNodes; i++) {
		INode *node;
		pblock2->GetValue(pb_nodes,t,node,valid,i);
		if (node) {
			ObjectState tos =  node->EvalWorldState(t,TRUE);
			if (tos.obj->IsParticleSystem()) {
				IParticleObjectExt* epobj;
				epobj = (IParticleObjectExt*) tos.obj->GetInterface(PARTICLEOBJECTEXT_INTERFACE);
				if (epobj) {
					MyEnumProc dep(false);              
					tos.obj->DoEnumDependents(&dep);
					for (int i = 0; i < dep.Nodes.Count(); i++) {
						Interval valid;
						INode *node = dep.Nodes[i];
						Object *obj = node->GetObjectRef();
						if ((obj) && (obj->GetInterface(PARTICLEGROUP_INTERFACE)))
							pfNodes.Append(1,&node);						
					}
				}
			}
		}
	}
	if (pfNodes.Count() > 0) {
		int iret = (int)DialogBoxParam(hInstance,MAKEINTRESOURCE(IDD_ADD_DIALOG),hWnd,AddDlgProc,(LPARAM)this);
		if ((iret) && (addPFNodes.Count() > 0)) {
			theHold.Begin();
			for (int i = 0; i < addPFNodes.Count(); i++) {
				int index = addPFNodes[i];
				INode *node = pfNodes[index];
				pblock2->Append(pb_pflow,1,&node);
			}
			theHold.Accept(GetString(IDS_ADDEVENTS));
		}
	}  
}

void BerconMetaball::PickNodesMode() {
	if (inPickMode) {
		inPickMode = FALSE;
		ip->ClearPickMode();
	} else if (ip && (!inPickMode))	{
		inPickMode = TRUE;
		thePickMode.obj = this;
		ip->SetPickMode(&thePickMode);
	}
}

/*
	############ PickControlNode ############
*/

BOOL PickControlNode::Filter(INode *node) {
	for (int i = 0; i < obj->pblock2->Count(pb_nodes); i++)	{
		if (node == obj->pblock2->GetINode(pb_nodes, 0, i))
			return FALSE;
	}
	node->BeginDependencyTest();
	obj->NotifyDependents(FOREVER,0,REFMSG_TEST_DEPENDENCY);
	if (node->EndDependencyTest()) {		
		return FALSE;
	} 
	return TRUE;
}

BOOL PickControlNode::HitTest(IObjParam *ip,HWND hWnd,ViewExp *vpt,IPoint2 m,int flags) {	
	if (ip->PickNode(hWnd,m,this))
		return TRUE;
	return FALSE;
}

BOOL PickControlNode::Pick(IObjParam *ip,ViewExp *vpt) {
	INode *node = vpt->GetClosestHit();
	if (node)  {
		theHold.Begin();
		obj->pblock2->Append(pb_nodes,1,&node);
		theHold.Accept(GetString(IDS_ADD));
		obj->NotifyDependents(FOREVER, GEOM_CHANNEL, REFMSG_CHANGE);
		obj->ip->RedrawViews(obj->ip->GetTime());
		macroRecorder->FunctionCall(_T("$.BerconMetaballOps.AddBlob"), 1, 0, mr_reftarg,node);
	}
	return FALSE;
}

void PickControlNode::EnterMode(IObjParam *ip) {}

HCURSOR PickControlNode::GetDefCursor(IObjParam *ip) {
    static HCURSOR hCur = NULL;
    if ( !hCur )
		hCur = LoadCursor(hInstance,MAKEINTRESOURCE(IDC_ARROW)); 	
	return hCur;
}

HCURSOR PickControlNode::GetHitCursor(IObjParam *ip) {
    static HCURSOR hCur = NULL;
    if ( !hCur ) 
		hCur = LoadCursor(hInstance,MAKEINTRESOURCE(IDC_CROSS));         
	return hCur;
}


void PickControlNode::ExitMode(IObjParam *ip) {
	ICustButton *iBut = GetICustButton(GetDlgItem(hWnd, IDC_PICK));
	if (iBut) {
		iBut->SetCheck( FALSE);
		ReleaseICustButton(iBut);
	}
	obj->inPickMode = FALSE;	
}

/*
	############ DumpHitDialog ############
*/

void DumpHitDialog::proc(INodeTab &nodeTab) {
	int nodeCount = nodeTab.Count(); 
	if (nodeCount == 0)
		return;
	theHold.Begin();
	for (int i=0;i<nodeTab.Count();i++) {
		eo->pblock2->Append(pb_nodes,1,&nodeTab[i]);
		macroRecorder->FunctionCall(_T("$.BerconMetaballOps.AddBlob"), 1, 0, mr_reftarg,nodeTab[i]);
	}
	theHold.Accept(GetString(IDS_ADD));
	eo->NotifyDependents(FOREVER, GEOM_CHANNEL, REFMSG_CHANGE);
	eo->ip->RedrawViews(eo->ip->GetTime());
}

int DumpHitDialog::filter(INode *node) {
	for (int i = 0; i < eo->pblock2->Count(pb_nodes); i++)
		if (node == eo->pblock2->GetINode(pb_nodes, 0, i))
			return FALSE;	
	node->BeginDependencyTest();
	eo->NotifyDependents(FOREVER,0,REFMSG_TEST_DEPENDENCY);
	if (node->EndDependencyTest())
		return FALSE;
	return TRUE;
}

/*
	############ BlobMeshValidatorClass ############
*/

BOOL BerconMetaballValidatorClass::Validate(PB2Value &v) {
   INode *node = (INode*) v.r;
   for (int i = 0; i < mod->pblock2->Count(pb_nodes); i++)
      if (node == mod->pblock2->GetINode(pb_nodes, 0, i))
         return FALSE;
   node->BeginDependencyTest();
   mod->NotifyDependents(FOREVER,0,REFMSG_TEST_DEPENDENCY);
   if (node->EndDependencyTest())     
		return FALSE;      
   return TRUE;
}

/*
	############ BerconMetaballParamsDlgProc ############
*/

INT_PTR BerconMetaballParamsDlgProc::DlgProc(TimeValue t,IParamMap2 *map, HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam) {
	switch (msg) {
		case WM_INITDIALOG: {
			// Add items to dropdown menu
			HWND hwndMap = GetDlgItem(hWnd, IDC_FIELDFUNCTION);  
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_POWER2));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_POWER3));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_POWER4));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_POWER5));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_HERMIT2));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_HERMIT4));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_WYVILL));			

			hwndMap = GetDlgItem(hWnd, IDC_FIELDFUNCTION2);  
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_NONE));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_SAME));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_POWER2));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_POWER3));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_POWER4));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_POWER5));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_HERMIT2));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_HERMIT4));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_FIELD_WYVILL));		
			// Set correct dropdown value
			int curIndex;
			map->GetParamBlock()->GetValue(pb_fieldFunction, t, curIndex, FOREVER);
			SendMessage(GetDlgItem(hWnd, IDC_FIELDFUNCTION), CB_SETCURSEL, (WPARAM)curIndex, 0);
			map->GetParamBlock()->GetValue(pb_color, t, curIndex, FOREVER);
			SendMessage(GetDlgItem(hWnd, IDC_FIELDFUNCTION2), CB_SETCURSEL, (WPARAM)curIndex, 0);
			break;
		}
		case WM_SHOWWINDOW:	{
			// Set correct dropdown value
			int curIndex;
			map->GetParamBlock()->GetValue(pb_fieldFunction, t, curIndex, FOREVER);
			SendMessage(GetDlgItem(hWnd, IDC_FIELDFUNCTION), CB_SETCURSEL, (WPARAM)curIndex, 0);
			map->GetParamBlock()->GetValue(pb_color, t, curIndex, FOREVER);
			SendMessage(GetDlgItem(hWnd, IDC_FIELDFUNCTION2), CB_SETCURSEL, (WPARAM)curIndex, 0);
			break;
		}
		default:
			break;
	}
	return FALSE;
}

/*
	############ BerconMetaballNodesDlgProc ############
*/

INT_PTR BerconMetaballNodesDlgProc::DlgProc(TimeValue t,IParamMap2 *map, HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam) {
	switch (msg) {
		case WM_INITDIALOG:
			obj->hWndNode = hWnd;		
			obj->DisableButtons(hWnd);			
			break;
		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDC_PICK: {
					thePickMode.hWnd = hWnd;
					obj->PickNodesMode();
					ICustButton *iBut = GetICustButton(GetDlgItem(hWnd, IDC_PICK));
					if (iBut) {
						iBut->SetType(CBT_CHECK);
						iBut->SetCheck(obj->inPickMode);
						ReleaseICustButton(iBut);
					}
					break;
				}
				case IDC_ADD: {
					obj->ip->DoHitByNameDialog(new DumpHitDialog(obj));
					break;
				}
			}
		break;
	}
	return FALSE;
}

/*
	############ BerconMetaballPFlowDlgProc ############
*/

INT_PTR BerconMetaballPFlowDlgProc::DlgProc(TimeValue t,IParamMap2 *map, HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam) {
	switch (msg) {
		case WM_INITDIALOG:
			obj->hWndPF = hWnd;	
			if (GetCOREInterface()->GetCommandPanelTaskMode() == TASK_MODE_CREATE) {
				EnableWindow(GetDlgItem(hWnd,IDC_ADDPF_EVENT_BUTTON),FALSE);
			}					
			break;
		case WM_COMMAND: 			
			switch (LOWORD(wParam)) {
				case IDC_ADDPF_EVENT_BUTTON:
					obj->PickPFEvents(hWnd);
					break;
				}
			break;
		}
	return FALSE;
}

/*
	############ BerconMetaballTextureDlgProc ############
*/

INT_PTR BerconMetaballTextureDlgProc::DlgProc(TimeValue t,IParamMap2 *map, HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam) {
	switch (msg) {
		case WM_INITDIALOG: {
			// Add items to dropdown menu
			HWND hwndMap = GetDlgItem(hWnd, IDC_TEXMODE);  
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_MULTIPLY));
			SendMessage(hwndMap, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_SUBTRACT));
			// Set correct dropdown value
			int curIndex;
			map->GetParamBlock()->GetValue(pb_textype, t, curIndex, FOREVER);
			SendMessage(GetDlgItem(hWnd, IDC_TEXMODE), CB_SETCURSEL, (WPARAM)curIndex, 0);
			break;
		}
		case WM_SHOWWINDOW:	{
			// Set correct dropdown value
			int curIndex;
			map->GetParamBlock()->GetValue(pb_textype, t, curIndex, FOREVER);
			SendMessage(GetDlgItem(hWnd, IDC_TEXMODE), CB_SETCURSEL, (WPARAM)curIndex, 0);
			break;
		}
		default:
			break;
	}
	return FALSE;
}


