/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements. The ASF licenses this
file to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.   
*/

#include "BerconShadeContext.h"

BerconShadeContext::BerconShadeContext(/*Matrix3 tm, Matrix3 itm*/) {
	mode = SCMODE_NORMAL;
	doMaps = TRUE;
	filterMaps = FALSE; // TODO: Should we filter or not?
	mtlNum = 0;
	shadow = FALSE;
	backFace = FALSE;
	ambientLight = Color(1.0f, 1.0f, 1.0f);
	nLights = 0;
	rayLevel = 0;
	//this->tm = tm;
	//this->itm = itm;
}

void BerconShadeContext::Init(Point3 worldPos) {
	this->worldPos = worldPos;
	//this->localPos = worldPos * itm;
}

Point3 BerconShadeContext::PointTo(const Point3& p, RefFrame ito) {
	Point3 res = p;
	//if (ito == REF_WORLD)		
		//res = res * tm;
	return res;
}

Point3 BerconShadeContext::PointFrom(const Point3& p, RefFrame ifrom) {
	Point3 res = p;
	//if (ifrom == REF_WORLD)		
		//res = res * itm;
	return res;
}

Point3 BerconShadeContext::VectorTo(const Point3& p, RefFrame ito) {
	Point3 res = p;
	//if (ito == REF_WORLD)		
		//res = tm.VectorTransform(res);
	return res;

}

Point3 BerconShadeContext::VectorFrom(const Point3& p, RefFrame ifrom) {
	Point3 res = p;
	//if (ifrom == REF_WORLD)		
		//res = itm.VectorTransform(res);
	return res;
}